/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.render.chunk.compile.buffers;

import net.caffeinemc.mods.sodium.api.util.ColorABGR;
import net.caffeinemc.mods.sodium.api.util.ColorARGB;
import net.caffeinemc.mods.sodium.api.util.NormI8;
import net.caffeinemc.mods.sodium.client.model.quad.properties.ModelQuadFacing;
import net.caffeinemc.mods.sodium.client.render.chunk.compile.buffers.ChunkModelBuilder;
import net.caffeinemc.mods.sodium.client.render.chunk.terrain.material.Material;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.TranslucentGeometryCollector;
import net.caffeinemc.mods.sodium.client.render.chunk.vertex.format.ChunkVertexEncoder;
import net.caffeinemc.mods.sodium.client.render.texture.SpriteFinderCache;
import net.minecraft.class_1058;
import net.minecraft.class_4588;
import org.jetbrains.annotations.NotNull;

public class ChunkVertexConsumer
implements class_4588 {
    private static final int ATTRIBUTE_POSITION_BIT = 1;
    private static final int ATTRIBUTE_COLOR_BIT = 2;
    private static final int ATTRIBUTE_TEXTURE_BIT = 4;
    private static final int ATTRIBUTE_LIGHT_BIT = 8;
    private static final int ATTRIBUTE_NORMAL_BIT = 16;
    private static final int REQUIRED_ATTRIBUTES = 31;
    private final ChunkModelBuilder modelBuilder;
    private final ChunkVertexEncoder.Vertex[] vertices = ChunkVertexEncoder.Vertex.uninitializedQuad();
    private Material material;
    private int vertexIndex;
    private int writtenAttributes;
    private TranslucentGeometryCollector collector;

    public ChunkVertexConsumer(ChunkModelBuilder modelBuilder) {
        this.modelBuilder = modelBuilder;
    }

    public void setData(Material material, TranslucentGeometryCollector collector) {
        this.material = material;
        this.collector = collector;
    }

    @NotNull
    public class_4588 method_22912(float x, float y, float z) {
        ChunkVertexEncoder.Vertex vertex = this.vertices[this.vertexIndex];
        vertex.x = x;
        vertex.y = y;
        vertex.z = z;
        vertex.ao = 1.0f;
        this.writtenAttributes |= 1;
        return this.potentiallyEndVertex();
    }

    @NotNull
    public class_4588 method_1336(int red, int green, int blue, int alpha) {
        ChunkVertexEncoder.Vertex vertex = this.vertices[this.vertexIndex];
        vertex.color = ColorABGR.pack(red, green, blue, alpha);
        this.writtenAttributes |= 2;
        return this.potentiallyEndVertex();
    }

    @NotNull
    public class_4588 method_22915(float red, float green, float blue, float alpha) {
        ChunkVertexEncoder.Vertex vertex = this.vertices[this.vertexIndex];
        vertex.color = ColorABGR.pack(red, green, blue, alpha);
        this.writtenAttributes |= 2;
        return this.potentiallyEndVertex();
    }

    @NotNull
    public class_4588 method_39415(int argb) {
        ChunkVertexEncoder.Vertex vertex = this.vertices[this.vertexIndex];
        vertex.color = ColorARGB.toABGR(argb);
        this.writtenAttributes |= 2;
        return this.potentiallyEndVertex();
    }

    @NotNull
    public class_4588 method_22913(float u, float v) {
        ChunkVertexEncoder.Vertex vertex = this.vertices[this.vertexIndex];
        vertex.u = u;
        vertex.v = v;
        this.writtenAttributes |= 4;
        return this.potentiallyEndVertex();
    }

    @NotNull
    public class_4588 method_60796(int u, int v) {
        return this.potentiallyEndVertex();
    }

    @NotNull
    public class_4588 method_22922(int uv) {
        return this.potentiallyEndVertex();
    }

    @NotNull
    public class_4588 method_22921(int u, int v) {
        ChunkVertexEncoder.Vertex vertex = this.vertices[this.vertexIndex];
        vertex.light = (v & 0xFFFF) << 16 | u & 0xFFFF;
        this.writtenAttributes |= 8;
        return this.potentiallyEndVertex();
    }

    @NotNull
    public class_4588 method_60803(int uv) {
        ChunkVertexEncoder.Vertex vertex = this.vertices[this.vertexIndex];
        vertex.light = uv;
        this.writtenAttributes |= 8;
        return this.potentiallyEndVertex();
    }

    @NotNull
    public class_4588 method_22914(float x, float y, float z) {
        this.writtenAttributes |= 0x10;
        return this.potentiallyEndVertex();
    }

    public class_4588 potentiallyEndVertex() {
        if (this.writtenAttributes != 31) {
            return this;
        }
        ++this.vertexIndex;
        this.writtenAttributes = 0;
        if (this.vertexIndex == 4) {
            int normal = this.calculateNormal();
            ModelQuadFacing cullFace = ModelQuadFacing.fromPackedNormal(normal);
            if (this.material.isTranslucent() && this.collector != null) {
                this.collector.appendQuad(normal, this.vertices, cullFace);
            }
            this.modelBuilder.getVertexBuffer(cullFace).push(this.vertices, this.material);
            float u = 0.0f;
            float v = 0.0f;
            for (ChunkVertexEncoder.Vertex vertex : this.vertices) {
                u += vertex.u;
                v += vertex.v;
            }
            class_1058 sprite = SpriteFinderCache.forBlockAtlas().find(u * 0.25f, v * 0.25f);
            if (sprite != null) {
                this.modelBuilder.addSprite(sprite);
            }
            this.vertexIndex = 0;
        }
        return this;
    }

    private int calculateNormal() {
        float y2 = this.vertices[2].y;
        float y0 = this.vertices[0].y;
        float dy0 = y2 - y0;
        float z3 = this.vertices[3].z;
        float z1 = this.vertices[1].z;
        float dz1 = z3 - z1;
        float z2 = this.vertices[2].z;
        float z0 = this.vertices[0].z;
        float dz0 = z2 - z0;
        float y3 = this.vertices[3].y;
        float y1 = this.vertices[1].y;
        float dy1 = y3 - y1;
        float normX = dy0 * dz1 - dz0 * dy1;
        float x3 = this.vertices[3].x;
        float x1 = this.vertices[1].x;
        float dx1 = x3 - x1;
        float x2 = this.vertices[2].x;
        float x0 = this.vertices[0].x;
        float dx0 = x2 - x0;
        float normY = dz0 * dx1 - dx0 * dz1;
        float normZ = dx0 * dy1 - dy0 * dx1;
        float length = (float)Math.sqrt(normX * normX + normY * normY + normZ * normZ);
        if ((double)length != 0.0 && (double)length != 1.0) {
            normX /= length;
            normY /= length;
            normZ /= length;
        }
        return NormI8.pack(normX, normY, normZ);
    }
}

