/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.search;

import com.google.common.base.Suppliers;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import me.shedaniel.rei.api.client.search.SearchFilter;
import me.shedaniel.rei.api.client.search.SearchProvider;
import me.shedaniel.rei.api.client.search.method.InputMethod;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.impl.client.search.argument.Argument;
import me.shedaniel.rei.impl.client.search.argument.CompoundArgument;
import me.shedaniel.rei.impl.client.search.argument.type.ArgumentType;
import me.shedaniel.rei.impl.common.InternalLogger;
import me.shedaniel.rei.impl.common.util.HashedEntryStackWrapper;

public class SearchProviderImpl
implements SearchProvider {
    @Override
    public void startReload() {
    }

    @Override
    public SearchFilter createFilter(String filter, InputMethod<?> inputMethod) {
        return new SearchFilterImpl(filter, inputMethod);
    }

    public static class SearchFilterImpl
    implements SearchFilter {
        private final String filter;
        private final InputMethod<?> inputMethod;
        private final Supplier<List<CompoundArgument>> arguments;
        private final Supplier<List<ArgumentType<?, ?>>> argumentTypes;

        public SearchFilterImpl(String filter, InputMethod<?> inputMethod) {
            this.filter = filter;
            this.inputMethod = inputMethod;
            this.arguments = Suppliers.memoize(() -> Argument.bakeArguments(filter));
            this.argumentTypes = Suppliers.memoize(() -> this.arguments.get().stream().flatMap(Collection::stream).flatMap(Collection::stream).map(Argument::getArgument).distinct().collect(Collectors.toList()));
            InternalLogger.getInstance().debug("Created search filter with \"%s\" using %s", filter, inputMethod.getName().getString());
        }

        @Override
        public boolean test(EntryStack<?> stack, long hashExact) {
            try {
                return Argument.matches(stack, hashExact, this.arguments.get(), this.inputMethod);
            }
            catch (Throwable throwable) {
                throw new RuntimeException("Failed to test search filter: \"" + this.filter + "\" with stack [" + String.valueOf(stack.getType().getIdentifier()) + "@" + String.valueOf(stack.getIdentifier()) + "!" + String.valueOf(stack.getValue()) + "]", throwable);
            }
        }

        @Override
        public boolean test(EntryStack<?> stack) {
            return this.test(stack, EntryStacks.hashExact(stack));
        }

        @Override
        public void prepareFilter(Collection<EntryStack<?>> stacks) {
            Argument.cache.prepareFilter(CollectionUtils.map(stacks, HashedEntryStackWrapper::new), (Collection)this.argumentTypes.get());
        }

        @Override
        public String getFilter() {
            return this.filter;
        }

        public List<ArgumentType<?, ?>> getArgumentTypes() {
            return this.argumentTypes.get();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SearchFilterImpl that = (SearchFilterImpl)o;
            return Objects.equals(this.filter, that.filter);
        }

        public int hashCode() {
            return Objects.hash(this.filter);
        }
    }
}

