/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.common.logging.performance;

import com.google.common.base.Stopwatch;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.Object2LongLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongMaps;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import me.shedaniel.rei.api.common.plugins.REIPlugin;
import me.shedaniel.rei.api.common.plugins.REIPluginProvider;
import me.shedaniel.rei.impl.common.logging.performance.PerformanceLogger;

public class PerformanceLoggerImpl
implements PerformanceLogger {
    private final Map<String, PluginImpl> stages = Collections.synchronizedMap(Maps.newLinkedHashMap());

    @Override
    public PerformanceLogger.Plugin stage(String stage) {
        PluginImpl plugin = this.stages.computeIfAbsent(stage, $ -> new PluginImpl());
        plugin.stopwatch.start();
        return plugin;
    }

    @Override
    public Map<String, PerformanceLogger.Plugin> getStages() {
        return this.stages;
    }

    @Override
    public void clear() {
        this.stages.clear();
    }

    private static class PluginImpl
    implements PerformanceLogger.Plugin {
        private final Stopwatch stopwatch = Stopwatch.createUnstarted();
        private long totalTime = 0L;
        private Object2LongMap<Object> times = Object2LongMaps.synchronize((Object2LongMap)new Object2LongLinkedOpenHashMap());

        private PluginImpl() {
        }

        @Override
        public PerformanceLogger.Plugin.Inner stage(String stage) {
            Stopwatch s = Stopwatch.createStarted();
            return () -> {
                s.stop();
                this.times.put((Object)stage, this.times.getOrDefault((Object)stage, 0L) + s.elapsed(TimeUnit.NANOSECONDS));
            };
        }

        @Override
        public PerformanceLogger.Plugin.Inner plugin(Pair<REIPluginProvider<?>, REIPlugin<?>> plugin) {
            Stopwatch s = Stopwatch.createStarted();
            return () -> {
                s.stop();
                this.times.put((Object)plugin, this.times.getOrDefault((Object)plugin, 0L) + s.elapsed(TimeUnit.NANOSECONDS));
            };
        }

        @Override
        public void close() {
            this.stopwatch.stop();
            this.totalTime += this.stopwatch.elapsed(TimeUnit.NANOSECONDS);
            this.stopwatch.reset();
        }

        @Override
        public long totalNano() {
            return this.totalTime;
        }

        @Override
        public Map<Object, Long> times() {
            return this.times;
        }
    }
}

